 unit adt856;
 
 interface
 type MyFunc = procedure();
 type ArcPointer = array[0..5] of single;
 function adt856_initial():integer;stdcall;
// /*
// Function: Initialize motion card
// Return value:Return value is the quantity of ADT-856 cards in the system. Value 3 indiates
// that three cards have been installed and available card numbers are 0, 1 and 2;
// Value 0 indicates that no ADT-856 card has been installed;
// Value -1 indicates that the drivers of ADT-856 card haven't been installed
// */
// 
 function adt856_end():integer;stdcall;
// /*
// Function:Release the resources of motion card
// Return value :        0:correct          1:wrong	
// */
 function set_stop0_mode(cardno:integer; axis:integer; value:integer;logic:integer):integer;stdcall;
// /*
// Function :Setup of STOP0 signal valid /invalid and logic electric level
// Parameter:
// cardno	  card number
// axis		  axis number(1-4)
// value		  0:invalid		 1:valid
// logic		  0:low electric stop	 1:high electric stop
// Return value:         0:correct          1:wrong
// Default modes       Signal is invalidlow electric stop
// Notice:
// The way to stop rests on that it is A/D drive or uniform acceleration drive. For former it is A/D stop while for latter instant stop. STOP1 and STOP2 are just the same
// */
 function set_stop1_mode(cardno:integer;axis:integer;value:integer;logic:integer):integer;stdcall;
// /*
// Function :Setup of STOP1 signal valid /invalid and logic electric level
// Parameter:
// cardno	  card number
// axis		  axis number(1-4)
// value		  0:invalid		 1:valid
// logic		  0:low electric stop	 1:high electric stop
// Return value  :       0:correct          1:wrong
// Default modes       Signalinvalidlow electric stop
// */
// 
 function set_stop2_mode(cardno:integer;axis:integer;value:integer;logic:integer):integer;stdcall;
// /*
// Function: Setup of STOP2 signal valid /invalid and logic electric level
// Parameter:
// cardno	  card number
// axis		  axis number(1-4)
// value		  0:invalid		 1:valid
// logic		  0:low electric stop	 1:high electric stop
// Return value  :       0:correct          1:wrong
// Default modes       Signalinvalidlow electric stop
// Notice
// STOP2 signal can clear actual position counter when it is valid. Due to the delay of servo system or mechanical system, error may occur in home position if you clear the actual position counter with software after driving. With this function, you can get higher precision.
// */
// 
 function set_actualcount_mode(cardno:integer;axis:integer;value:integer;dir:integer;freq:integer):integer;stdcall;
// /*
// Function :Set working mode of actual position counte
// Parameter:
// cardno	   card number
// axis		axis number(1-4)
// value	    Pulse input mode
// 0:A/B pulse input		
// 1:Up/Down (PPIN/PMIN) pulse input
// dir	   Counting direction
// 0: A leads B or PPIN pulse input up count
// B leads A or PMIN pulse input down count
// 1:B leads A or PMIN pulse input up count
// A leads B or PPIN pulse input down count
// freq	 Frequency multiplication of A/B pulse input Invalid for Up/Down pulse input
// 0: 4     1: 2        2: 1
// Return value  :       0:correct          1:wrong
// Default modes      A/B pulse inputdirection: 0Frequency multiplication: 4
// */
// 
 function set_pulse_mode(cardno:integer;axis:integer;value:integer; logic:integer; dir_logic:integer):integer;stdcall;
// /*
// Function :Set working mode of output pulse
// Parameter :
// cardno	     card number
// axis		  axis number(1-4)
// value		  0:Pulse + Pulse	1:Pulse + Direction
// logic		  0:Positive logical pulse		1:Negative logical pulse
// dir-logic	0: Positive direction pulse output 	
// 1:Negative direction pulse output
// Return value :         0:correct          1:wrong
// Default mode    Pulse + direction; positive logical pulse; Positive logic of direction output signal
// */
// 
 function set_limit_mode(cardno:integer; axis:integer; value:integer;logic:integer):integer;stdcall;
// /*
// Function :Set the mode of positive/negative limit input signal nLMT
// Parameter :
// cardno	     card number
// axis		  axis number(1-4)
// value		  0:sudden stop		1:decelerated stop0:sudden stop	     1:decelerated stop
// logic		  0:low electric valid	1:high electric valid
// Return value :        0:correct         1:wrong
// Default modes       sudden stoplow electric valid
// Notice
// The limit signal can't be valid or invalid.
// */
 function set_softlimit_mode1(cardno:integer; axis:integer; value:integer):integer;stdcall;
// /*
// Function :Set COMP + register as software limit
// Parameter
// cardno	     card number
// axis		  axis number(1-4)
// value		  0:invalid			 1:valid
// Return value         0:correct          1:wrong
// Default modes       invalid
// Notice
// Software limit is always decelerated stop and the counting value may exceed the setting value. It is necessary to consider this point while setting range
// */
 function set_softlimit_mode2(cardno:integer;axis:integer; value:integer):integer;stdcall;
// /*
// Function :Set COMP - register as software limit
// Parameter
// cardno	     card number
// axis		  axis number(1-4)
// value		  0:invalid			 1:valid
// Return value         0:correct          1:wrong
// Default modes       invalid
// Notice :The same as above
// */
// 
 function set_softlimit_mode3(cardno:integer; axis:integer; value:integer):integer;stdcall;
// /*
// Function :set COMP+/- registers as the compare objects of software limit
// Parameter
// cardno	     card number
// axis		  axis number(1-4)
// value		  0:Logical position counter    1:Actual position counter
// Return value         0:correct          1:wrong
// Default modes       Logical position counter
// This function is the comparison object of setting software limit.
// */
// 
 function set_inpos_mode( cardno:integer; axis:integer; value:integer; logic:integer):integer;stdcall;
// /*
// Function :Setting of servo in-position signal nINPOS
// Parameter
// cardno	     card number
// axis		  axis number(1-4)
// value		  0:invalid			 1:valid
// logic		  0:low electricvalid	 1:high electricvalid
// Return value         0:correct          1:wrong
// Default modes       invalidlow electricvalid
// Notice
// Do not select valid if nINPOS isn't connected to servo or stepping motor is used.
// */
// 
 function set_alarm_mode(cardno:integer; axis:integer; value:integer; logic:integer):integer;stdcall;
// /*
// Function :Set the working mode of servo alarm signal nALARM
// Parameter
// cardno	     card number
// axis		  axis number(1-4)
// value		  0:invalid				1:valid
// logic		  0:low electric valid		1:high electric valid
// Return value         0:correct             1:wrong
// Default modes       invalidlow electric valid
// Notice
// Do not select valid if nALARM isn't connected to servo or stepping motor is used
// */
 function set_ad_mode( cardno:integer; axis:integer; value:integer):integer;stdcall;
// /*
// Function :Select linear or S-curve acceleration/deceleration
// Parameter
// cardno	     card number
// axis		  axis number(1-4)
// value		  0:linear A/D   1:S-curve A/D
// Return value         0:correct          1:wrong
// Default modes       linear A/D
// */
// 
 function set_dec1_mode( cardno:integer; axis:integer; value:integer):integer;stdcall;
// /*
// Function :Select symmetric or asymmetric acceleration/deceleration
// Parameter
// cardno	    card number
// axis		 axis number(1-4)
// value	    deceleration  mode
// (0: symmetric deceleration, 1: asymmetric deceleration)
// Return value         0:correct          1:wrong
// Default modes       symmetric acceleration/deceleration
// */
// 
 function set_dec2_mode( cardno:integer; axis:integer; value:integer):integer;stdcall;
// /*
// Function :Set deceleration mode
// Parameter
// cardno	     card number
// axis		  axis number(1-4)
// value		  0:automatic deceleration		1: manual deceleration
// Return value         0:correct             1:wrong
// Default modes       Automatic deceleration
// Notice 
// Automatic deceleration is used in most cases. To use manual deceleration, it is necessary to set deceleration point
// */
 function set_circle_mode(cardno:integer; axis:integer; value:integer):integer;stdcall;
// /*
// Function :Set the variable circle mode of counter
// Parameter
// cardno	     card number
// axis		  axis number(1-4)
// value  	     0:invalid			 1:valid
// Return value         0:correct          1:wrong
// Default modes       invalid
// */
// 
 function set_input_filter(cardno:integer; axis:integer; number:integer; value:integer):integer;stdcall;
// /*
// Function :Set the filtering function of input signal
// Parameter
// cardno	 card number
// 	axis		 axis number
// 	number	 Input types
// 			 1:LMT+LMT-STOP0STOP1
// 			 2:STOP2
// 			 3:nINPOSnALARM
// 			 4:nIN
// 			 Set the filtering state of the four types input signals above
// 	value	 0: Filtering invalid       1: Filtering valid
// Return value          0:correct          1:wrong
// Default modes       invalid
// */
// 
 function set_filter_time(cardno:integer; axis:integer; value:integer):integer;stdcall
// /*
// Function :Set the filtering time constant of input signals
// Parameter
// cardno	   card number
// axis		axis number
// value	   Range: 1-8
// */
// 
// //----------------------------------------------------//
// //               Driving status checking              //
// //----------------------------------------------------//
// 
// 
 function get_status( cardno:integer; axis:integer;value:PInteger):integer;stdcall;
// /*
// Function:Get the driving status of single axis
// Parameter
// cardno	      card number
// axis		  axis number(1-4)
// value		  Index of driving status; the meanings are:
// 0: Driving stopped
// Return value         0:correct          1:wrong
// Notice
// If single axis driving command is executed, you can send next driving instruction to the axis when the driving of corresponding axis is stopped. Otherwise, previous driving instruction stops immediately and next instruction is executed.
// */
// 
 function get_stopdata( cardno:integer; axis:integer; value:PInteger):integer;stdcall;
// /*
// Function:Get the error stop data of axes
// Parameter
// cardno	      card number
// axis		  axis number(1-4)
// value	       Index of error status
// 	 		  0: No error
// Return value         0:correct          1:wrong
// */
 function get_inp_status( cardno:integer; no:integer;value:PInteger):integer;stdcall;
// /*
// Function:Get the driving status of interpolation
// Parameter
// cardno	      card number
// value		 Index of interpolation status
// 			 0: Interpolation stopped	1: Interpolating
// Return value         0:correct          1:wrong
// Notice
// If interpolation driving command is executed, you can send next driving instruction to the axis when the interpolation driving of corresponding axis is stopped. Otherwise, previous driving instruction stops immediately and next instruction is executed.
// */
 function get_inp_status2( cardno:integer; no:integer;value:PInteger):integer;stdcall;
// /*
// Function:Get the writable status of continuous interpolation
// Parameter
// cardno	       card number
// value		  Index of writing status
// 0: Unwritable	   1: Writable
// Return value         0:correct          1:wrong
// Notice
// If the driving is stopped, the status is 0. Threrfore, it is necessary to check whether error occurs in continuous interpolation process.
// */
// 
// 
// //----------------------------------------------------//
// //               Moving parameter settings            //
// //----------------------------------------------------//
// 
// 
 function set_range( cardno:integer; axis:integer; Value:longint):integer;stdcall;
// /*
// Function:set range
// Parameter		
// cardno	  card number
// axis		  axis number(1-4)
// value  	  range(8000000-16000)
// Return value         0:correct          1:wrong
// */
// 
 function set_acac(cardno:integer; axis:integer; Value:longint):integer;stdcall;
// /*
// Function:Set the change rate of acceleration/deceleration
// Parameter
// cardno	 card number
// axis		 axis number(1-4)
// value	     range(1-65535)
// Return value         0:correct          1:wrong
// */
// 
 function set_acc( cardno:integer;axis:integer; Value:longint):integer;stdcall;
// /*
// Function:Set the value of acceleration
// Parameter
// cardno	 card number
// axis		 axis number(1-4)
// value	     range(1-8000)
// Return value         0:correct          1:wrong
// */
// 
 function set_dec(cardno:integer; axis:integer; Value:longint):integer;stdcall;
// /*
// Function:Set the value of deceleration
// Parameter
// cardno	  card number
// axis		  axis number(1-4)
// value	      D-value(1-8000)
// Return value         0:correct          1:wrong
// */
// 
 function set_startv( cardno:integer; axis:integer; Value:longint):integer;stdcall;
// /*
// Function:Set the value of start velocity
// Parameter
// cardno	  card number
// axis		  axis number(1-4)
// value	  range(1-8000)
// Return value         0:correct          1:wrong
// */
// 
 function set_speed( cardno:integer; axis:integer; Value:longint):integer;stdcall;
// /*
// Function:Set the value of run velocity
// Parameter
// cardno	  card number
// axis		  axis number(1-4)
// value	  range(1-8000)
// Return value         0:correct          1:wrong
// */
 function set_command_pos( cardno:integer; axis:integer; Value:longint):integer;stdcall;
// /*
// Function:Set the value of logical position counter
// Parameter
// cardno	 card number
// axis		 axis number(1-4)
// value	    range value(-2147483648~+2147483647)
// Return value         0:correct          1:wrong
// Notice          
// You can access the logical position counter in real time
// */
 function set_actual_pos(cardno:integer; axis:integer; Value:longint):integer;stdcall;
// /*
// Function:Set the value of actual position counter
// Parameter
// cardno	  card number
// axis		  axis number(1-4)
// value	     range value(-2147483648~+2147483647)
// Return value         0:correct          1:wrong
// Notice          
// You can access the actual position counter in real time
// */
// 
 function set_comp1( cardno:integer;axis:integer; Value:longint):integer;stdcall;
// /*
// Function:Set the value of COMP+ register
// Parameter
// cardno	  card number
// axis		  axis number(1-4)
// value	     range value(-2147483648~+2147483647)
// Return value         0:correct          1:wrong
// Notice
// You can access the COMP+ register in real time
// */
// 
 function set_comp2( cardno:integer;axis :integer; Value:longint):integer;stdcall;
// /*
// Function:Set the value of COMP- register
// Parameter
// cardno	  card number
// axis		  axis number(1-4)
// value	      range value(-2147483648~+2147483647)
// Return value         0:correct          1:wrong
// Notice          
// You can access the COMP- register in real time
// */
// 
 function set_dec_pos( cardno:integer;axis:integer; Value:longint):integer;stdcall;
// /*
// Function:Set the value of COMP+ register
// Parameter
// cardno	  card number
// axis		  axis number(1-4)
// value	     range value(0~268435455)
// Return value         0:correct          1:wrong
// Notice
// If manual deceleration mode is used, you need to set manual deceleration point first.Manual deceleration point = output pulses - pulses consumed by deceleration
// */
// 
// 
// //----------------------------------------------------//
// //        Moving parameter checking                   //
// //----------------------------------------------------//
// 
// 
 function get_command_pos( cardno:integer; axis:integer;pos:PInteger):integer;stdcall;
// /*
// Function:Get the logical position of axes
// Parameter
// cardno	  card number
// axis		  axis number(1-4)
// pos		  Index of logical position value
// Return value         0:correct          1:wrong
// Notice
// You can use this function to get the logical position of axes and it can represent the current position of axes if the motor is not out of step
// */
// 
 function get_actual_pos( cardno:integer; axis:integer; pos:PInteger):integer;stdcall;
// /*
// Function:Get the actual position of axis
// Parameter
// cardno	  card number
// axis		  axis number(1-4)
// pos		  Index of actual position value
// Return value         0:correct          1:wrong
// Notice
// You can use this function to get the actual position of axes and you can get the current position of axes even if the motor is out of step.
// */
// 
 function get_speed( cardno:integer; axis:integer; pos:PInteger):integer;stdcall;
// /*
// Function:Get the current driving speed of axes
// Parameter
// cardno	  card number
// axis		  axis number(1-4)
// speed	     Index of current driving speed
// Return value         0:correct          1:wrong
// Notice:Value of actual speed = Getting speed*M = Getting speed*(8000000/R)
// */
 function get_ad( cardno:integer; axis:integer;pos:PInteger):integer;stdcall;
// /*
// Function:Get the current acceleration of axes
// Parameter
// cardno	  card number
// axis		  axis number(1-4)
// ad		     Index of current acceleration
// Return value         0:correct          1:wrong
// */
// 
// 
// //----------------------------------------------------//
// //                  Basic driving                     //
// //----------------------------------------------------//
// 
// 
 function pmove(icardno:integer; axis:integer; pulse:longint):integer;stdcall;
// /*
// Function:Single axis quantitative driving
// Parameter
// 		cardno 	    card number
// 		axis		    axis number(1-4)
// 		pulse	   output pulses   >0: Positive		 <0: Negative
// 				    range(-268435455~+268435455)
// Return value         0:correct          1:wrong
// Notice
// You need to set valid speed parameter before writing driving command.
// */
// 
 function continue_move(cardno:integer; axis:integer; dir:integer):integer;stdcall;
// /*
// Function:Single axis continuous driving
// Parameter
// 		cardno 	  card number
// 		axis		  axis number(1-4)
// 		dir		 Driving direction   0: Positive	 1: Negative
// Return value         0:correct          1:wrong
// 	Notice
// You need to set valid speed parameter before writing driving command.
// */
// 
 function dec_stop(cardno:integer; axis:integer):integer;stdcall;
// /*
// Function:Stop current driving process in deceleration
// Parameter
// 	cardno	   card number
// 		axis		   axis number(1-4)
// Return value         0:correct          1:wrong
// Notice
// This command is decelerated stop in acceleration/deceleration driving, process and sudden stop in constant speed driving process.
// */
 function sudden_stop( cardno:integer; axis:integer):integer;stdcall;
// /*
// Function:Stop current driving process immediately
// Parameter
// cardno	  card number
// axis		  axis number(1-4)
// Return value         0:correct          1:wrong
// Notice
// Stop pulse output immediately in acceleration/deceleration and constant speed driving process.
// */
// 
 function inp_move2(cardno:integer; no:integer;pulse1:longint;pulse2:longint):integer;stdcall;
// /*
// Function:Two axes linear interpolation
// Parameter
// cardno	  card number
// axis1		  Interpolation axis number1(1-4indicate :XYZA)
// axis2      Interpolation axis number2(1-4indicate :XYZA)
// pulse1       Moving distance of axis1 
// pulse2	       Moving distance of axis2 
// Return value         0:correct          1:wrong
// 	Notice
// The interpolation speed takes the speed of the axis with smaller axis number between axis1 and axis2 as the standard.
// */
// 
 function inp_cw_arc( cardno:integer; no:integer; x:longint; y:longint; i:longint; j:longint):integer;stdcall;
// /*
// Function:Two axes CW arc interpolation
// Parameter
// cardno	    card number
// no          1:X-Y    2:Z-W
// x,y		   End point position of arc interpolation (relative to start point)
// i,j		 Circle center position of arc interpolation (relative to start point)
// Return value         0:correct          1:wrong
// Notice
// The X-Y interpolation takes the speed of X-axis as base,Y-axis do not need to set.
// The Z-W interpolation takes the speed of Z-axis as base,A-axis do not need to set.
// */
 function inp_ccw_arc( cardno:integer; no:integer; x:longint; y:longint; i:longint; j:longint):integer;stdcall;
// /*
// Function:Two axes CCW arc interpolation
// Parameter
// cardno	  card number
// no          1:X-Y    2:Z-W
// x,y		   End point position of arc interpolation (relative to start point)
// i,j		 Circle center position of arc interpolation (relative to start point
//  Return value         0:correct          1:wrong
// Notice
// The X-Y interpolation takes the speed of X-axis as base,Y-axis do not need to set.
// The Z-W interpolation takes the speed of Z-axis as base,A-axis do not need to set.
// */
// 
 function inp_move3(cardno:integer;pulse1:longint;pulse2:longint;pulse3:longint):integer;stdcall;
// /*
// Function:Three axes linear interpolation
// Parameter
// cardno 	   card number
// pulse1,pulse2,pulse3	    Moving distance of axis X,Y,Z (range:-8388608~+8388607)
// Only X,Y,Z could be used with three axes linear interpolation
// Return value         0:correct          1:wrong
// Notice 
// The interpolation speed takes the speed of the axis X as the standard (axis1).the magnification 
//  and running speed of Z-axis must be the same as X-axis.The start speed of Z-Axis must be the same
//  as running speed of X-axis (not start speed),Y-axis do not need to set.
// */
// 
 function inp_move4(cardno:integer;pulse1:longint;pulse2:longint;pulse3:longint;pulse4:longint):integer;stdcall;
// /*
// Function:Four axes linear interpolation
// Parameter
// cardno 	   card number
// pulse1       Moving distance of X-axis
// pulse2	     Moving distance of Y-axis
// pulse3       Moving distance of Z-axis
// pulse4	     Moving distance of W-axis
// Return value         0:correct          1:wrong
// Notice
// The interpolation speed takes the speed of the axis X as the standard (axis1).the magnification 
// and running speed of Z-axis must be the same as X-axis.The start speed of Z-Axis must be the same
// as running speed of X-axis (not start speed),Y,W-axis do not need to set.
// */
 function inp_move6(cardno:integer;pulse1:longint;pulse2:longint;pulse3:longint;pulse4:longint;pulse5:longint;pulse6:longint):integer;stdcall;
// /*
// Function:Four axes linear interpolation
// Parameter
// cardno 	   card number
// pulse1       Moving distance of axis1
// pulse2	     Moving distance of axis2
// pulse3       Moving distance of axis3
// pulse4	     Moving distance of axis4
// pulse5       Moving distance of axis5
// pulse6	     Moving distance of axis6
// Return value         0:correct          1:wrong
// Notice
// The interpolation speed takes the speed of the axis X as the standard (axis1).the magnification 
// and running speed of Z-axis,,U-axis must be the same as X-axis.The start speed of Z-axis,U-axis must be the same
// as running speed of X-axis (not start speed),Y ,W, V axis do not need to set.
// */
// 
 function inp_dec_enable( cardno:integer; no:integer):integer;stdcall;
// /*
// Function:Enable deceleration of interpolation
// Parameter
// cardno	     card number
// Return value         0:correct          1:wrong
// */
 function inp_dec_disable(cardno:integer; no:integer):integer;stdcall;
// /*
// Function:Disable deceleration of interpolation
// Parameter
// cardno	    card number
// Return value         0:correct          1:wrong
// */
 function inp_clear( cardno:integer):integer;stdcall;
// /*
// Function:clean the error of interpolation 
// Parameter
// cardno	    card number
// Return value         0:correct          1:wrong
// */
// 
// //----------------------------------------------------//
// //              Switch quantity input/output          //
// //----------------------------------------------------//
// 
// 
 function read_bit( cardno:integer; number:integer):integer;stdcall;
// /*
// Function:Get the status of single input bit
// Parameter	
// cardno	 card number
// number	input bit (0-47)
// Return value         0:low electric     1:high electric  -1:wrong
// */
 function write_bit( cardno:integer; number:integer; value:integer):integer;stdcall;
// /*
// Function:Corresponding port performs output operation.
// Parameter		
// cardno	  card number
// number	  output bit(0-31)
// value		  0:low		     1:high
// Return value         0:correct          1:wrong
// */
